----------------
title : C 언어 레퍼런스 - malloc 함수
cat_title :  malloc
ref_title : malloc
path : /C Reference/stdlib.h
----------------

##@ cpp-ref-start

#@ malloc 

`stdlib.h` 에 정의됨

```cpp-formatted
void* malloc(size_t size);
```

**메모리를 할당한다.**

인자로 전달된 크기 만큼의 메모리를 할당 한 후에, 그 메모리의 시작 주소값을 리턴한다.

할당된 메모리는 초기화 되지 않았을 수 도 있다. 즉, 기존에 있었던 내용이 남아 있을 수 도 있다.

만일 `size` 가 0 이라면, `malloc` 이 무엇을 리턴할지는 구현한 라이브러리 마다 다르다. 어떤 경우 널 포인터를 리턴할 수 도 있고, 어떤 경우, 널이 아닌 포인터를 리턴하지만, 사용 불가능한 부분을 가리키고 있을 수 도 있다. 어떤 경우든, 해당 주소값을 사용하면 안된다.

참고로 할당한 메모리는 반드시 `free` 로 해제 해줘야 한다.

### 인자들

* `size` : 메모리 블록의 크기 (바이트 단위). 참고로 `size_t` 는 음이 아닌 정수 타입이다.

### 리턴값

메모리 할당에 성공하였을 경우, 할당한 메모리 블록을 가리키는 포인터를 리턴한다. 해당 포인터의 타입은 언제나 `void*` 이기에, 사용자가 사용을 원하는 타입으로 캐스팅 해줘야만 한다.

만일, `malloc` 함수가 메모리 할당에 실패하였을 경우, 널 포인터를 리턴한다.

### 실행 예제

```cpp-formatted
/*

  원하는 길이의 랜덤 문자열을 생성한다.
  (임의의 길이의 문자열을 담는 메모리 공간을 위해 malloc 사용)

  http://www.cplusplus.com/reference/cstdlib/malloc/
  에서 가져왔습니다.

*/
#include <stdio.h>  /* printf, scanf, NULL */
#include <stdlib.h> /* malloc, free*/

int main() {
  int i, n;
  char* buffer;

  printf("How long do you want the string? ");
  scanf("%d", &i);

  buffer = (char*)malloc(i + 1);
  if (buffer == NULL) exit(1);

  for (n = 0; n < i; n++) buffer[n] = rand() % 26 + 'a';
  buffer[i] = '\0';

  printf("Random string: %s\n", buffer);
  free(buffer);

  return 0;
}
```

실행 결과

```exec
How long do you want the string? 10
Random string: nwlrbbmqbh
```

### 참고 자료

* `free` : 메모리를 해제한다.
* `calloc` : 0 으로 초기화된 메모리를 할당한다.
* `realloc` : 메모리를 재할당 한다.